## Dimension Properties

Retrieve member's properties.




### Description

The [DIMENSION] PROPERTIES statement allows for retrieving properties of the members on each axis. Note that contrary to the GetProperty function, parent properties are not accessible from the children.

Should you want to <b>directly add member properties as columns to the result</b>, please have a look to the [Dimension Properties](../post_processing/DimensionProperties.md) post processor.

Properties can be retrieved for a certain context (aka. scope). For example, the following query is retrieving the [Country] property for each member of the level [Geography].[Geography].[City] :

<pre>

SELECT
  [Measures].[#Sales] on 0
  [Geography].[Geography].allMembers
    dimension properties [Geography].[Geography].[City].[Country] on 1
FROM [Sales]

</pre>

The context/scope can be a dimension, a hierarchy, a level or a member.

The values of the properties are accessible as a tooltip of the members in the table and pivot table both in the Dashboards application and the MDX IDE application. In the Dashboards application, you can add them as columns of the result using the "Add Column" transformation.

Member properties are either <b>intrinsic</b> or <b>custom</b>. Custom properties are also known as [user defined](Member%20Custom%20Property.md) properties.

Properties can be <b>context-sensitive</b> : these properties <b>must</b> be used in the context of a specific dimension, hierarchy, level or member. The following query is retrieving the [Country] property for the members of the [Geography].[Geography].[City] level only :

<pre>

SELECT
  [Measures].[#Sales] on 0
  non empty [Geography].[Geography].allMembers * [Time].[Time].[Years]
    dimension properties [Geography].[Geography].[City].[Country] on 1
FROM [Sales]

</pre>

<b>Context-insensitive</b> properties can be retrieved without any context. The following query is retrieving the PARENT_UNIQUE_NAME property for all the members in the axis 1 :

<pre>

SELECT
  [Measures].[#Sales] on 0
  non empty [Geography].[Geography].allMembers * [Time].[Time].[Years]
    dimension properties PARENT_UNIQUE_NAME on 1
FROM [Sales]

</pre>

<b>Intrinsic Properties</b>

|Name|Description|Context Sensitive|
|-|-|-|
|CAPTION                     | The localized name of the member. ||
|CHILDREN_CARDINALITY        | The number of children of the member. ||
|CUBE_NAME                   | The name of the cube the member belongs to. ||
|DESCRIPTION                 | Equivalent to NAME. ||
|DIMENSION_UNIQUE_NAME       | The unique name of the dimension the member belongs to. ||
|HIERARCHY_UNIQUE_NAME       | The unique name of the hierarchy the member belongs to. ||
|KEY                         | The key of the member. |true|
|KEYx                        | The key of the member, where x is the zero-based ordinal of the key. KEY0 is available for composite and non-composite keys. If the key is non-composite, then KEY0 is equivalent to Key. ||
|LCIDx                       | The translation of the member caption in the locale ID hexadecimal value, where x is the locale ID decimal value. ||
|LEVEL_NUMBER                | The distance of the member from the root of the hierarchy. The root level is zero. ||
|LEVEL_TYPE                  | The type of the level the member belongs to : applies to date/time level only. ||
|LEVEL_UNIQUE_NAME           | The unique name of the level the member belongs to. ||
|MEASURE_GROUP_NAME          |||
|MEMBER_CAPTION              | The localized name of the member. ||
|MEMBER_KEY                  | The key of the member. ||
|MEMBER_NAME                 | The name of the member. ||
|MEMBER_TYPE                 | The type of the member. ||
|MEMBER_UNIQUE_NAME          | The unique name of the member. ||
|NAME                        | The name of the member. |true|
|PARENT_COUNT                | The number of parents of the member : 0 or 1. ||
|PARENT_LEVEL                | The distance of the member's parent from the root level of the hierarchy. The root level is zero.||
|PARENT_UNIQUE_NAME          | The unique name of the member's parent. ||
|PATH_TO_ROOT                | A comma separated list of unique names. ||
|UNIQUE_NAME                 | The unique name of the member. ||



                                                                      

### See Also


[Member Custom Property](Member%20Custom%20Property.md)

[Member Attributes](Member%20Attributes.md)

[Properties](Properties.md)

[GetProperty](GetProperty.md)

[GetPropertyUniqueValues](GetPropertyUniqueValues.md)

[Cell Properties](Cell%20Properties.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
